-- This replaces FillType.SILAGE with FillType.GRASS_FERMENTED within the active missions on each sellingStation as soon as addFillLevelFromTool is called, meaning as soon as something is trying to sell.
-- While not the most elegant this seems the easiest to make Silage missions work. Also there is no reason why a bale shouldn't be GRASS_FERMENTED with MaizePlus installed in an active grass mission so.. this shouldn't cause any issues.
-- Reworked by Braeven (Farming Agency) 02.01.2023 - Fixed displaying issue, that made silage missions look like hay missions

baleMissionGrassFermented = {}

function baleMissionGrassFermented.addFillLevelFromTool(self, superFunc, farmId, deltaFillLevel, fillType, fillInfo, toolType, extraAttributes)

	-- cycle through all missions attached to sellingStation and change fillType SILAGE to GRASS_FERMENTED
	for _, mission in pairs(self.missions) do
		if mission.fillType == FillType.SILAGE then
			mission.fillType = Utils.getNoNil(FillType.GRASS_FERMENTED, mission.fillType)		
		end
	end	
	
	-- call original func 
	return superFunc(self, farmId, deltaFillLevel, fillType, fillInfo, toolType, extraAttributes)
end
SellingStation.addFillLevelFromTool = Utils.overwrittenFunction(SellingStation.addFillLevelFromTool, baleMissionGrassFermented.addFillLevelFromTool)


function baleMissionGrassFermented:getData()
	if self.sellPointId ~= nil then
		self:tryToResolveSellPoint()
	end

	local l10nString = nil

	if self.fillType == FillType.SILAGE or self.fillType == FillType.GRASS_FERMENTED then
		l10nString = "fieldJob_desc_baling_silage"
	else
		l10nString = "fieldJob_desc_baling_hay"
	end

	return {
		location = string.format(g_i18n:getText("fieldJob_number"), self.field.fieldId),
		jobType = g_i18n:getText("fieldJob_jobType_baling"),
		action = g_i18n:getText("fieldJob_desc_action_baling"),
		description = string.format(g_i18n:getText(l10nString), self.field.fieldId, self.sellPoint:getName())
	}
end

BaleMission.getData = Utils.overwrittenFunction(BaleMission.getData, baleMissionGrassFermented.getData)