-- overriding animal data via XML file 

-- by modelleicher (Farming Agency)

animalDataOverride = {}

local modDirectory = g_currentModDirectory

-- add XML Schema
g_xmlManager:addCreateSchemaFunction(function ()
	animalDataOverride.xmlSchema = XMLSchema.new("animalDataOverride")
end)

function animalDataOverride.loadAnimalData(self, superFunc, xmlFile, baseDir)

    local returnValue = superFunc(self, xmlFile, baseDir)

	-- default path within M+
	local path = modDirectory.."xml/maizePlus_animalDataOverride.xml"
	
    -- check if FS22_maizePlus_animalFoodAdditions mod is present and loaded 
    local mod = g_modManager:getModByName("FS22_maizePlus_animalFoodAdditions")
    if mod ~= nil and g_modIsLoaded["FS22_maizePlus_animalFoodAdditions"] then
            
        -- check if file exists and adjust path, otherwise warning print
        if fileExists(mod.modDir.."maizePlus_animalDataOverride.xml") then
            path = mod.modDir.."maizePlus_animalDataOverride.xml"
        else
            print("MaizePlus Info: No maizePlus_animalDataOverride.xml in FS22_maizePlus_animalFoodAdditions found. Default MaizePlus animal Data Overrides loaded.")
        end
    end;   
	
    -- check if FS22_maizePlus_hofBergmann_animalFoodAdditions mod is present and loaded 
    local mod = g_modManager:getModByName("FS22_maizePlus_hofBergmann_animalFoodAdditions")
    if mod ~= nil and g_modIsLoaded["FS22_maizePlus_hofBergmann_animalFoodAdditions"] then
            
        -- check if file exists and adjust path, otherwise warning print
        if fileExists(mod.modDir.."maizePlus_animalDataOverride.xml") then
            path = mod.modDir.."maizePlus_animalDataOverride.xml"
        else
            print("MaizePlus Info: No maizePlus_animalDataOverride.xml in FS22_maizePlus_hofBergmann_animalFoodAdditions found. Default MaizePlus animal Data Overrides loaded.")
        end
    end;   

    if fileExists(path) then

        local schema = animalDataOverride.xmlSchema
        local basePath = "animalDataOverride"

        schema:register(XMLValueType.STRING, basePath .. ".animalData(?)#type", "Type of Animal this Dataset overrides", nil)   
        schema:register(XMLValueType.STRING, basePath .. ".animalData(?)#subType", "Sub-Type Animal for this Dataset", "COW_SWISS_BROWN")      
        schema:register(XMLValueType.STRING, basePath .. ".animalData(?).inputs#overrideType", "The type of override, 'add' will only add/replace for this input-type while 'replace' will replace all the inputs with the new ones.", nil)
        schema:register(XMLValueType.STRING, basePath .. ".animalData(?).outputs#overrideType", "The type of override, 'add' will only add/replace for this output-type while 'replace' will replace all the outputs with the new ones.", nil)
        schema:register(XMLValueType.STRING, basePath .. ".animalData(?).inputs.input(?)#type", "Input-Type most likely Filltype", "STRAW")
        schema:register(XMLValueType.STRING, basePath .. ".animalData(?).outputs.output(?)#type", "Output-Type most likely Filltype", "MILK")
        schema:register(XMLValueType.STRING, basePath .. ".animalData(?).inputs.input(?).key#ageMonth", "Age-Month for this particular animation-key element", "0")
        schema:register(XMLValueType.STRING, basePath .. ".animalData(?).inputs.input(?).key#value", "Value this particular animation-key element", "0")
        schema:register(XMLValueType.STRING, basePath .. ".animalData(?).outputs.output(?).key#ageMonth", "Age-Month for this particular animation-key element", "0")
        schema:register(XMLValueType.STRING, basePath .. ".animalData(?).outputs.output(?).key#value", "Value this particular animation-key element", "0")

        local xml = XMLFile.load("animalDataOverride", path , animalDataOverride.xmlSchema)

        -- go through all animalData entries
        local animalDataIndex = 0
        while true do
            local curPath = basePath..".animalData("..animalDataIndex..")"
            local type = xml:getValue(curPath.."#type")
            if type == nil then -- exit if type is nil
                break
            else
                -- find subType through name
                local subType = xml:getValue(curPath.."#subType")
                if self.nameToSubType[subType] ~= nil then
                    -- found subType
                    local subType = self.nameToSubType[subType]

                    -- go througn inputs
                    local overrideTypeInput = xml:getValue(curPath..".inputs#overrideType")
                    if overrideTypeInput ~= nil then
                        if overrideTypeInput == "replace" then
                            subType.input = {}
                        end
                    
                        local inputIndex = 0
                        while true do
                            local inputPath = curPath..".inputs.input("..inputIndex..")"
                            local inputType = xml:getValue(inputPath.."#type")
                            if inputType == nil then
                                break
                            else   
                                subType.input[inputType] = self:loadAnimCurve(xml, inputPath)
                            end
                            inputIndex = inputIndex +1
                        end
                    end

                    -- go through outputs
                    local overrideTypeOutput = xml:getValue(curPath..".outputs#overrideType")
                    if overrideTypeOutput ~= nil then
                        if overrideTypeOutput == "replace" then
                            subType.output = {}
                        end
                    
                        local outputIndex = 0
                        while true do
                            local outputPath = curPath..".outputs.output("..outputIndex..")"
                            local outputType = xml:getValue(outputPath.."#type")
                            if outputType == nil then
                                break
                            else   
                                subType.output[outputType] = self:loadAnimCurve(xml, outputPath)
                            end
                            outputIndex = outputIndex +1
                        end                   
                    end
                end
            end
            animalDataIndex = animalDataIndex + 1
        end
    end

    return returnValue
end

AnimalSystem.loadAnimals = Utils.overwrittenFunction(AnimalSystem.loadAnimals, animalDataOverride.loadAnimalData)
 