-- @titel       LessMotorBrakeforce Script for FarmingSimulator 2022
-- @author      s4t4n aka SbSh
-- @version     v1.0.0.0 Release Modhub
-- @version		v1.0.0.1 Small Changes(FS22 1.2.0.2)
-- @date        23/12/2022
-- edit			26/07/2023
-- @info        LessMotorBrakeforce Script for FarmingSimulator 2022
-- changed		app to pre 23.12.2022 SbSh(s4t4n)
-- changelog	adaptation to FS22_realismAddon_gearbox from modelleicher
--				and other script mods were in conflict
--				just keep functional while new ls updates

LessMotorBrakeforce = {};
LessMotorBrakeforce.printed = false;
function LessMotorBrakeforce.prerequisitesPresent(specializations)
    return true
end;
function LessMotorBrakeforce:onUpdate(dt)
	if self.spec_CVTaddon ~= nil then
		if not LessMotorBrakeforce.printed then
			print("### LessMotorBrakeforce is deactivated, because FS22_CVT_Addon is active. ###")
			print("### Please use just one of the both mods. ###")
			LessMotorBrakeforce.printed = true;
		end
	else
		if self.LessMotorBrakeforce == nil then
			self.LessMotorBrakeforce = true;

			if self.spec_motorized ~= nil then
				if self.spec_motorized.motor ~= nil then
					if self.spec_motorized.motor.lowBrakeForceScale ~= nil and self.spec_motorized.motor.lastManualShifterActive == false and self.spec_motorized.motor.groupType == 1 and self.spec_motorized.motor.gearType == 1 and self.spec_motorized.motor.forwardGears then
						-- 0.45 = -55% less BrakeForce
						self.spec_motorized.motor.lowBrakeForceScale = self.spec_motorized.motor.lowBrakeForceScale*0.45; -- adjust here if want, remember - all clints and server have to be the same value.
					end;
				end;
			end;
		end;
	end;
end;
Drivable.onUpdate  = Utils.prependedFunction(Drivable.onUpdate, LessMotorBrakeforce.onUpdate);

