-- Author:RedFoxModding
-- Name:FruitsAdjustment
-- Version: 1.0.0.0
-- Development: Jun.22
-- Date: 06.07.2022
-- Email: my.games1050@gmail.com
-- Copyright (c) RedFoxModding, 2022

-- V 1.0.0.0:
--FS22 Complete rework and implementation


--ToDo :
-- Adjust fruitTypeConverters for chaff
-- Adjust yield of greenland fruits
-- Factory support
-- Adjust growth

FruitsAdjustment = {}
FruitsAdjustment.modDir = g_currentModDirectory

FruitsAdjustment.seedUsage = {} 					-- Seedusage 		L/m2
FruitsAdjustment.literPerSqm = {}					-- Yield 			L/m2
FruitsAdjustment.windrowLiterPerSqm = {}			-- Windrow Yield	L/m2
FruitsAdjustment.pricePerLiter = {}					-- Price per Liter  €/L
FruitsAdjustment.massPerLiter = {}					-- Mass per Liter   kg/L

function FruitsAdjustment:loadFromXML()
	local i = 0
	local xmlFilename = "FruitsAdjustment.xml"
	local path = FruitsAdjustment.modDir .. xmlFilename
	local object = "fruitsAdjustment"
	local key = "fruitsAdjustment.FruitTypes.fruitType"
	local xmlFileId = loadXMLFile(object, path) 
	local name
	
	while true do
		local keySub = string.format("%s(%d)", key, i)
		if not hasXMLProperty(xmlFileId, keySub) then
			break
		end
		
		name = getXMLString(xmlFileId, keySub.."#name")
		
		if hasXMLProperty(xmlFileId, keySub.."#seedUsagePerSqm") then
			FruitsAdjustment.seedUsage[name] = getXMLString(xmlFileId, keySub.."#seedUsagePerSqm")
		end
		
		if hasXMLProperty(xmlFileId, keySub.."#literPerSqm") then
			FruitsAdjustment.literPerSqm[name] = getXMLString(xmlFileId, keySub.."#literPerSqm")
		end
		
		if hasXMLProperty(xmlFileId, keySub.."#windrowLiterPerSqm") then
			FruitsAdjustment.windrowLiterPerSqm[name] = getXMLString(xmlFileId, keySub.."#windrowLiterPerSqm")
		end
		
		i = i + 1
	end
	
	i = 0
	key = "fruitsAdjustment.FillTypes.fillType"
	
	while true do
		local keySub = string.format("%s(%d)", key, i)
		if not hasXMLProperty(xmlFileId, keySub) then
			break
		end
		
		name = getXMLString(xmlFileId, keySub.."#name")
		
		if hasXMLProperty(xmlFileId, keySub.."#massPerLiter") then
			FruitsAdjustment.massPerLiter[name] = getXMLString(xmlFileId, keySub.."#massPerLiter")
		end
		
		if hasXMLProperty(xmlFileId, keySub.."#pricePerLiter") then
			FruitsAdjustment.pricePerLiter[name] = getXMLString(xmlFileId, keySub.."#pricePerLiter")
		end
		
		i = i + 1
	end
	
	
end

function FruitsAdjustment:loadMap(name)
	
	for k, v in pairs(g_currentMission.fruitTypeManager.fruitTypes) do
		if FruitsAdjustment.seedUsage[v.name] ~= nil then
			v.seedUsagePerSqm = FruitsAdjustment.seedUsage[v.name]
			--print("FruitsAdjustment: "..tostring(v.name).." Seed usage changed to "..tostring(v.seedUsagePerSqm*10000).." Liters per ha.")
		end
		
		if FruitsAdjustment.literPerSqm[v.name] ~= nil then
			v.literPerSqm = FruitsAdjustment.literPerSqm[v.name]
			--print("FruitsAdjustment: "..tostring(v.name).." Yield changed to "..tostring(v.literPerSqm*10000).." Liters per ha.")
		end
		
		if FruitsAdjustment.windrowLiterPerSqm[v.name] ~= nil then
			v.windrowLiterPerSqm = FruitsAdjustment.windrowLiterPerSqm[v.name]
			--print("FruitsAdjustment: "..tostring(v.name).." Windrow Yield changed to "..tostring(v.windrowLiterPerSqm*10000).." Liters per ha.")
		end
	end
	--print("FruitsAdjustment: Fruits adjusted")
	
	for m, w in pairs(g_currentMission.fillTypeManager.fillTypes) do
		if FruitsAdjustment.pricePerLiter[w.name]~= nil then
			w.pricePerLiter = tonumber(FruitsAdjustment.pricePerLiter[w.name])
			--print("FruitsAdjustment: "..tostring(w.name).." Sellprice changed to "..tostring(w.pricePerLiter*1000).." Euro per 1000L.")
		end
		
		if FruitsAdjustment.massPerLiter[w.name]~= nil then
			w.massPerLiter = tonumber(FruitsAdjustment.massPerLiter[w.name]/1000)
			--print("FruitsAdjustment: "..tostring(w.name).." Mass changed to "..tostring(w.massPerLiter*1000).." kg per m3.")
		end
		
	end
	
	--print("FruitsAdjustment: Filltypes adjusted")
	print("FruitsAdjustment FS22 by RedFoxModding loaded")
	print("FruitsAdjustment: Everything is adjusted - Have fun :)")
end

FruitsAdjustment:loadFromXML()
addModEventListener(FruitsAdjustment)
