--
-- FS22 - FieldLease
--
-- @Interface: 1.2.0.0 b14651
-- @Author: KR-Softwares
-- @Date: 16.02.2022
-- @Version: 1.1.0.0
--
-- @Support: kr-softwares.com
--
-- Changelog:
-- 	v1.1.0.0 (16.02.2022):
-- 		- Fix ui for large screens
-- 	v1.0.0.0 (24.01.2022):
--      - Convert from from FS19 to FS22
--

FieldLease = {}
FieldLease.dir = g_currentModDirectory
FieldLease.modName = g_currentModName

source(FieldLease.dir .. "KrSoftwareUtils.lua")
source(FieldLease.dir .. "gui/InGameMenuFieldLease.lua")
source(FieldLease.dir .. "FarmlandLeaseStateEvent.lua")

function FieldLease:loadMap()
	KrSoftwareUtils.loadTextFromMod(FieldLease.modName, FieldLease.dir)
	KrSoftwareUtils.mergeModTranslations(g_i18n)

	local ui = g_currentMission.inGameMenu

    g_gui:loadProfiles(FieldLease.dir .. "gui/guiProfiles.xml")

	local guiFieldLease = InGameMenuFieldLease.new(g_i18n) 
	g_gui:loadGui(FieldLease.dir .. "gui/InGameMenuFieldLease.xml", "ingameMenuFieldLease", guiFieldLease, true)
		
	FieldLease.fixInGameMenu(guiFieldLease,"ingameMenuFieldLease", {0,0,1024,1024}, 2, FieldLease:makeIsFieldLeaseEnabledPredicate())

	guiFieldLease:initialize()	
	g_messageCenter:subscribe(MessageType.DAY_CHANGED, self.onDayChanged, self)

--[[
	local guiElementPage = FrameReferenceElement.new(ui)
	guiElementPage.referencedFrameName = "ingameMenuFieldLease"
	guiElementPage.name = "ingameMenuFieldLease"
	guiElementPage.id = "pageFieldLease"

	local index, varName = GuiElement.extractIndexAndNameFromID(guiElementPage.id)	
	if index then
		if not ui[varName] then
			ui[varName] = {}
		end

		ui[varName][index] = guiElementPage
	else
		ui[varName] = guiElementPage
	end

	ui.controlIDs[varName] = true
	
	guiFieldLease:initialize()	

	local filename = FieldLease.dir .. "images/menuIcon.dds"
	ui:addPage(guiFieldLease, nil, filename, {0,0,1024,1024}, FieldLease:makeIsFieldLeaseEnabledPredicate())
	
	ui:applyScreenAlignment()
	ui:updateAbsolutePosition()
	
	
	--ui.pageMapOverview.onClickBuyFarmland = FieldLease.onClickBuyFarmland(ui.pageMapOverview.onClickBuyFarmland)	
	]]--
end

function FieldLease:makeIsFieldLeaseEnabledPredicate()
	return function ()
		return true
	end
end

function FieldLease:delete()
	g_messageCenter:unsubscribeAll(self)	
end

function FieldLease:onDayChanged()
	if g_server ~= nil then
		local leased = {}
		for _, farmland in pairs(g_farmlandManager.farmlands) do
			if farmland.isOwned and farmland.isLeased then
				local farmId = g_farmlandManager.farmlandMapping[farmland.id]
				if leased[farmId] == nil then
					leased[farmId] = 0
				end
				leased[farmId] = leased[farmId] + (farmland.price * InGameMenuFieldLease.LEASE_MULTIPLIER)
			end
		end

		for farmId, money in pairs(leased) do
			g_currentMission:addMoney(money * -1, farmId, MoneyType.OTHER, true, true)
		end
	end
end


--[[
function FieldLease.onClickBuyFarmland(oldFunc)
	return function (s, ...)
		print("onClickBuyFarmland")
		if not GS_IS_MOBILE_VERSION and s.selectedFarmland ~= nil then
			local farmland = g_farmlandManager:getFarmlandById(s.selectedFarmland.id)
			if farmland ~= nil and farmland.isLeased then
				g_gui:showInfoDialog({
					title = g_i18n:getText("ui_fieldLease_noSellHeader"),
					text = g_i18n:getText("ui_fieldLease_noSell")
				})
				return
			end
		end
		oldFunc(s, ...)
	end
end
]]--

-- from Courseplay
function FieldLease.fixInGameMenu(frame,pageName,uvs,position,predicateFunc)
	local inGameMenu = g_gui.screenControllers[InGameMenu]

	-- remove all to avoid warnings
	for k, v in pairs({pageName}) do
		inGameMenu.controlIDs[v] = nil
	end

	inGameMenu:registerControls({pageName})

	
	inGameMenu[pageName] = frame
	inGameMenu.pagingElement:addElement(inGameMenu[pageName])

	inGameMenu:exposeControlsAsFields(pageName)

	for i = 1, #inGameMenu.pagingElement.elements do
		local child = inGameMenu.pagingElement.elements[i]
		if child == inGameMenu[pageName] then
			table.remove(inGameMenu.pagingElement.elements, i)
			table.insert(inGameMenu.pagingElement.elements, position, child)
			break
		end
	end

	for i = 1, #inGameMenu.pagingElement.pages do
		local child = inGameMenu.pagingElement.pages[i]
		if child.element == inGameMenu[pageName] then
			table.remove(inGameMenu.pagingElement.pages, i)
			table.insert(inGameMenu.pagingElement.pages, position, child)
			break
		end
	end

	inGameMenu.pagingElement:updateAbsolutePosition()
	inGameMenu.pagingElement:updatePageMapping()
	
	inGameMenu:registerPage(inGameMenu[pageName], position, predicateFunc)
	local iconFileName = Utils.getFilename('images/menuIcon.dds', FieldLease.dir)
	inGameMenu:addPageTab(inGameMenu[pageName],iconFileName, GuiUtils.getUVs(uvs))
	inGameMenu[pageName]:applyScreenAlignment()
	inGameMenu[pageName]:updateAbsolutePosition()

	for i = 1, #inGameMenu.pageFrames do
		local child = inGameMenu.pageFrames[i]
		if child == inGameMenu[pageName] then
			table.remove(inGameMenu.pageFrames, i)
			table.insert(inGameMenu.pageFrames, position, child)
			break
		end
	end

	inGameMenu:rebuildTabList()
end

addModEventListener(FieldLease)

-- Now we fixe some giants bugs :)
--[[
function fixGiantsBug1(oldFunc)
	return function (s, pageFrameElement, ...)
		local pageRoot, position = oldFunc(s, pageFrameElement, ...)
		pageRoot = pageFrameElement.elements[1]
		return pageRoot, position
	end
end

function fixGiantsBug2(oldFunc)
	return function (self, pageFrameElement, position, tabIconFilename, tabIconUVs, enablingPredicateFunction)
		local pageRoot, actualPosition = self:registerPage(pageFrameElement, position, enablingPredicateFunction)

	self:addPageTab(pageFrameElement, tabIconFilename, GuiUtils.getUVs(tabIconUVs))

	local name = pageRoot.title

	if name == nil then
		name = self.l10n:getText("ui_" .. pageRoot.name)
	end

	self.pagingElement:superClass().addElement(self.pagingElement, pageFrameElement)
	self.pagingElement:addPage(string.upper(pageRoot.name), pageFrameElement, name, actualPosition)
	end
end

TabbedMenu.registerPage = fixGiantsBug1(TabbedMenu.registerPage)
TabbedMenu.addPage = fixGiantsBug2(TabbedMenu.addPage)
]]--