--
-- FS22 - FieldLease - FarmlandLeaseStateEvent
--
-- @Interface: 1.2.0.0 b14651
-- @Author: KR-Softwares
-- @Date: 24.01.2022
-- @Version: 1.0.0.0
--
-- @Support: kr-softwares.com
--
-- Changelog:
-- 	v1.0.0.0 (24.01.2022):
--		Release fs22
--

FarmlandLeaseStateEvent = {}
local FarmlandLeaseStateEvent_mt = Class(FarmlandLeaseStateEvent, Event)

InitEventClass(FarmlandLeaseStateEvent, "FarmlandLeaseStateEvent")

function FarmlandLeaseStateEvent.emptyNew()
	local self = Event.new(FarmlandLeaseStateEvent_mt)

	return self
end

function FarmlandLeaseStateEvent.new(id, farmId, price, isLeased)
	local self = FarmlandLeaseStateEvent.emptyNew()
	self.id = id
	self.farmId = farmId
	self.price = price
	self.isLeased = isLeased

	return self
end

function FarmlandLeaseStateEvent:readStream(streamId, connection)
	self.id = streamReadUIntN(streamId, g_farmlandManager.numberOfBits)
	self.farmId = streamReadUIntN(streamId, FarmManager.FARM_ID_SEND_NUM_BITS)
	self.price = streamReadInt32(streamId)
	self.isLeased = streamReadBool(streamId)

	self:run(connection)
end

function FarmlandLeaseStateEvent:writeStream(streamId, connection)
	streamWriteUIntN(streamId, self.id, g_farmlandManager.numberOfBits)
	streamWriteUIntN(streamId, self.farmId, FarmManager.FARM_ID_SEND_NUM_BITS)
	streamWriteInt32(streamId, self.price)
	streamWriteBool(streamId, self.isLeased)
end

function FarmlandLeaseStateEvent:run(connection)
	if g_farmlandManager:getIsValidFarmlandId(self.id) then
		if not connection:getIsServer() then
			local currentOwner = g_farmlandManager:getFarmlandOwner(self.id)

			if self.farmId == FarmlandManager.NO_OWNER_FARM_ID or currentOwner == FarmlandManager.NO_OWNER_FARM_ID then
				local player = g_currentMission:getPlayerByConnection(connection)
				local farmAllowed = player ~= nil and g_currentMission:getHasPlayerPermission("farmManager", connection, player.farmId) and (player.farmId == self.farmId or currentOwner == player.farmId)

				if player ~= nil and player.farmId > 0 and farmAllowed then

					g_farmlandManager:getFarmlandById(self.id).isLeased = self.isLeased

					if self.price > 0 then
						local farmId = player.farmId
						local money = g_currentMission:getMoney(farmId)

						if self.farmId ~= FarmlandManager.NO_OWNER_FARM_ID then
							if money < self.price then
								return
							end

							g_currentMission:addMoney(-self.price, farmId, MoneyType.FIELD_BUY, true, true)
						else
							g_currentMission:addMoney(self.price, farmId, MoneyType.FIELD_SELL, true, true)
						end
					end

					g_server:broadcastEvent(self, true)
				end
			end
		else            
            g_farmlandManager:getFarmlandById(self.id).isLeased = self.isLeased
			g_farmlandManager:setLandOwnership(self.id, self.farmId)
			g_currentMission.inGameMenu.frameFieldLease:updateContent()
		end
	end
end

function FarmlandLeaseStateEvent:readStreamInitial(streamId, connection)
	for _, farmlandId in ipairs(g_farmlandManager.sortedFarmlandIds) do
		g_farmlandManager:getFarmlandById(farmlandId).isLeased = streamReadBool(streamId)
	end
end

function FarmlandLeaseStateEvent:writeStreamInitial(streamId, connection)
	for _, farmlandId in ipairs(g_farmlandManager.sortedFarmlandIds) do
		local farmland = g_farmlandManager:getFarmlandById(farmlandId)
		streamWriteBool(streamId, Utils.getNoNil(farmland.isLeased, false)) 
	end
	
end

FarmlandInitialStateEvent.readStream = Utils.appendedFunction(FarmlandInitialStateEvent.readStream, FarmlandLeaseStateEvent.readStreamInitial)
FarmlandInitialStateEvent.writeStream = Utils.appendedFunction(FarmlandInitialStateEvent.writeStream, FarmlandLeaseStateEvent.writeStreamInitial)