--
-- FS22 - FieldCalculator - SeedFrame
--
-- @Interface: 1.2.0.0 b14651
-- @Author: KR-Softwares
-- @Date: 23.01.2022
-- @Version: 1.0.0.0
--
-- @Support: kr-softwares.com
--
-- Changelog:
-- 	v1.0.0.0 (23.01.2022):
--      - Convert from from FS19 to FS22
--

SeedFrame = {
	CONTROLS = {
		DIALOG_TITLE = "dialogTitleElement",
		CLOSE_BUTTON = "closeButton",
        TABLE = "fieldCalculatorSeedTable",
        TABLE_TEMPLATE = "fieldCalculatorSeedRowTemplate"
	}
}
local SeedFrame_mt = Class(SeedFrame, MessageDialog)

function SeedFrame.new(target, custom_mt)
	local self = MessageDialog.new(target, custom_mt or SeedFrame_mt)

	self:registerControls(SeedFrame.CONTROLS)

	return self
end

function SeedFrame:onCreate()
	SeedFrame:superClass().onCreate(self)    
end

function SeedFrame:onGuiSetupFinished()
	SeedFrame:superClass().onGuiSetupFinished(self)
	self.fieldCalculatorSeedTable:setDataSource(self)
	self.fieldCalculatorSeedTable:setDelegate(self)
end

function SeedFrame:onOpen()
	SeedFrame:superClass().onOpen(self)
	FocusManager:setFocus(self.fieldCalculatorSeedTable)
end

function SeedFrame:setFieldData(fieldData)   
	if self.dialogTitleElement ~= nil then
        local headerText = string.format(g_i18n:getText("ui_seedFrame_header"), fieldData.fieldId, g_i18n:formatNumber(fieldData.fieldArea, 2))
		self.dialogTitleElement:setText(Utils.getNoNil(headerText, "No title"))
	end

    self.currentFieldArea = fieldData.fieldArea

    self.fuitsData = {
		{
			title = g_i18n:getText("ui_listHeader_free"),
			fruits = {}
		}
	}

    for _,fruit in pairs(g_fruitTypeManager:getFruitTypes()) do
        if fruit.allowsSeeding then
            table.insert(self.fuitsData[1].fruits, fruit)
        end        
	end
    
	self.fieldCalculatorSeedTable:reloadData()    
end

function SeedFrame:getNumberOfSections()
	return #self.fuitsData
end

function SeedFrame:getNumberOfItemsInSection(list, section)
	return #self.fuitsData[section].fruits
end

function SeedFrame:populateCellForItemInSection(list, section, index, cell)
	local fruitData = self.fuitsData[section].fruits[index]    
	cell:getAttribute("fruit"):setText(g_fillTypeManager:getFillTypeByName(fruitData.name).title)
	cell:getAttribute("consume"):setText(g_i18n:formatNumber(self.currentFieldArea * fruitData.seedUsagePerSqm * 10000, 2))
end

function SeedFrame:onClose()
	SeedFrame:superClass().onClose(self)
end

function SeedFrame:onClickBack(sender)
	self:close()
end