--
-- FS22 - FieldCalculator
--
-- @Interface: 1.2.0.0 b14651
-- @Author: KR-Softwares
-- @Date: 16.02.2022
-- @Version: 1.1.0.0
--
-- @Support: kr-softwares.com
--
-- Changelog:
-- 	v1.1.0.0 (16.02.2022):
-- 		- Fix ui for large screens
-- 	v1.0.0.0 (23.01.2022):
--      - Convert from from FS19 to FS22
--

FieldCalculator = {}
FieldCalculator.dir = g_currentModDirectory
FieldCalculator.modName = g_currentModName

source(FieldCalculator.dir .. "KrSoftwareUtils.lua")
source(FieldCalculator.dir .. "gui/InGameMenuFieldCalculator.lua")
source(FieldCalculator.dir .. "gui/SeedFrame.lua")

function FieldCalculator:loadMap()
	KrSoftwareUtils.loadTextFromMod(FieldCalculator.modName, FieldCalculator.dir)
	KrSoftwareUtils.mergeModTranslations(g_i18n)

	local ui = g_currentMission.inGameMenu

    g_gui:loadProfiles(FieldCalculator.dir .. "gui/guiProfiles.xml")

	local guiFieldCalculator = InGameMenuFieldCalculator.new(g_i18n) 
	g_gui:loadGui(FieldCalculator.dir .. "gui/InGameMenuFieldCalculator.xml", "ingameMenuFieldCalculator", guiFieldCalculator, true)
	
	local seedFrame = SeedFrame.new(g_i18n) 
	g_gui:loadGui(FieldCalculator.dir .. "gui/SeedFrame.xml", "SeedFrame", seedFrame)
	
	FieldCalculator.fixInGameMenu(guiFieldCalculator,"ingameMenuFieldCalculator", {0,0,1024,1024}, 2, FieldCalculator:makeIsFieldCalculatorEnabledPredicate())

	guiFieldCalculator:initialize()	

--[[
	local guiElementPage = FrameReferenceElement.new(ui)
	guiElementPage.referencedFrameName = "ingameMenuFieldCalculator"
	guiElementPage.name = "ingameMenuFieldCalculator"
	guiElementPage.id = "pageFieldCalculator"

	local index, varName = GuiElement.extractIndexAndNameFromID(guiElementPage.id)	
	if index then
		if not ui[varName] then
			ui[varName] = {}
		end

		ui[varName][index] = guiElementPage
	else
		ui[varName] = guiElementPage
	end

	ui.controlIDs[varName] = true
	

	local filename = FieldCalculator.dir .. "images/menuIcon.dds"
	ui:addPage(guiFieldCalculator, nil, filename, {0,0,1024,1024}, FieldCalculator:makeIsFieldCalculatorEnabledPredicate())
	
	ui:applyScreenAlignment()
	ui:updateAbsolutePosition()
	]]--
end

function FieldCalculator:makeIsFieldCalculatorEnabledPredicate()
	return function () return true end
end


-- from Courseplay
function FieldCalculator.fixInGameMenu(frame,pageName,uvs,position,predicateFunc)
	local inGameMenu = g_gui.screenControllers[InGameMenu]

	-- remove all to avoid warnings
	for k, v in pairs({pageName}) do
		inGameMenu.controlIDs[v] = nil
	end

	inGameMenu:registerControls({pageName})

	
	inGameMenu[pageName] = frame
	inGameMenu.pagingElement:addElement(inGameMenu[pageName])

	inGameMenu:exposeControlsAsFields(pageName)

	for i = 1, #inGameMenu.pagingElement.elements do
		local child = inGameMenu.pagingElement.elements[i]
		if child == inGameMenu[pageName] then
			table.remove(inGameMenu.pagingElement.elements, i)
			table.insert(inGameMenu.pagingElement.elements, position, child)
			break
		end
	end

	for i = 1, #inGameMenu.pagingElement.pages do
		local child = inGameMenu.pagingElement.pages[i]
		if child.element == inGameMenu[pageName] then
			table.remove(inGameMenu.pagingElement.pages, i)
			table.insert(inGameMenu.pagingElement.pages, position, child)
			break
		end
	end

	inGameMenu.pagingElement:updateAbsolutePosition()
	inGameMenu.pagingElement:updatePageMapping()
	
	inGameMenu:registerPage(inGameMenu[pageName], position, predicateFunc)
	local iconFileName = Utils.getFilename('images/menuIcon.dds', FieldCalculator.dir)
	inGameMenu:addPageTab(inGameMenu[pageName],iconFileName, GuiUtils.getUVs(uvs))
	inGameMenu[pageName]:applyScreenAlignment()
	inGameMenu[pageName]:updateAbsolutePosition()

	for i = 1, #inGameMenu.pageFrames do
		local child = inGameMenu.pageFrames[i]
		if child == inGameMenu[pageName] then
			table.remove(inGameMenu.pageFrames, i)
			table.insert(inGameMenu.pageFrames, position, child)
			break
		end
	end

	inGameMenu:rebuildTabList()
end

addModEventListener(FieldCalculator)


-- Now we fixe some giants bugs :)
--[[
function fixGiantsBug1(oldFunc)
	return function (s, pageFrameElement, ...)
		local pageRoot, position = oldFunc(s, pageFrameElement, ...)
		pageRoot = pageFrameElement.elements[1]
		return pageRoot, position
	end
end

function fixGiantsBug2(oldFunc)
	return function (self, pageFrameElement, position, tabIconFilename, tabIconUVs, enablingPredicateFunction)
		local pageRoot, actualPosition = self:registerPage(pageFrameElement, position, enablingPredicateFunction)

	self:addPageTab(pageFrameElement, tabIconFilename, GuiUtils.getUVs(tabIconUVs))

	local name = pageRoot.title

	if name == nil then
		name = self.l10n:getText("ui_" .. pageRoot.name)
	end

	self.pagingElement:superClass().addElement(self.pagingElement, pageFrameElement)
	self.pagingElement:addPage(string.upper(pageRoot.name), pageFrameElement, name, actualPosition)
	end
end

TabbedMenu.registerPage = fixGiantsBug1(TabbedMenu.registerPage)
TabbedMenu.addPage = fixGiantsBug2(TabbedMenu.addPage)
]]--