-- Name: EAS_AnimalsCanDieStateEvent
-- Author: Chissel

EAS_AnimalsCanDieStateEvent = {}

local EAS_AnimalsCanDieStateEvent_mt = Class(EAS_AnimalsCanDieStateEvent, Event)
InitEventClass(EAS_AnimalsCanDieStateEvent, "EAS_AnimalsCanDieStateEvent")

function EAS_AnimalsCanDieStateEvent.emptyNew()
    local self = Event.new(EAS_AnimalsCanDieStateEvent_mt)

    return self
end

function EAS_AnimalsCanDieStateEvent.new(animalsCanDieState, animalsCanDie)
    local self = EAS_AnimalsCanDieStateEvent.emptyNew()

    self.animalsCanDieState = animalsCanDieState
    self.animalsCanDie = animalsCanDie

    return self
end

function EAS_AnimalsCanDieStateEvent:readStream(streamId, connection)
    g_easUtils:logText("EAS_AnimalsCanDieStateEvent readStream")
    self.animalsCanDieState = streamReadInt32(streamId)
    self.animalsCanDie = streamReadBool(streamId)

    self:run(connection)
end

function EAS_AnimalsCanDieStateEvent:writeStream(streamId, connection)
    g_easUtils:logText("EAS_AnimalsCanDieStateEvent writeStream")
    streamWriteInt32(streamId, self.animalsCanDieState)
    streamWriteBool(streamId, self.animalsCanDie)
end

function EAS_AnimalsCanDieStateEvent:run(connection)
    local animalsCanDieState = self.animalsCanDieState
    local animalsCanDie = self.animalsCanDie

    g_easUtils:logText("Receive EAS_AnimalsCanDieStateEvent")

    g_easSettingsMenuExtension.animalsCanDieState = animalsCanDieState
    g_easSettingsMenuExtension.animalsCanDie = animalsCanDie

    g_easSettingsMenuExtension:updateGameSettings()

    if not connection:getIsServer() then
        g_server:broadcastEvent(EAS_AnimalsCanDieStateEvent.new(self.animalsCanDieState, self.animalsCanDie), false)
        g_easUtils:logText("Change animals can die setttings to: "..animalsCanDieState)
    end
end