-- Name: EAS_SettingsMenuExtension
-- Author: Chissel

EAS_SettingsMenuExtension = {}
EAS_SettingsMenuExtension.animalsCanDie = false
EAS_SettingsMenuExtension.animalsCanDieState = 1

function EAS_SettingsMenuExtension:init()
    g_easUtils:logText("EAS_SettingsMenuExtension created")

    InGameMenuGameSettingsFrame.onFrameOpen = Utils.appendedFunction(InGameMenuGameSettingsFrame.onFrameOpen, EAS_SettingsMenuExtension.onFrameOpen)
    InGameMenuGameSettingsFrame.updateGameSettings = Utils.appendedFunction(InGameMenuGameSettingsFrame.updateGameSettings, EAS_SettingsMenuExtension.updateGameSettings)

    Mission00.load = Utils.prependedFunction(Mission00.load, EAS_SettingsMenuExtension.loadFromXMLFile)
    Mission00.onStartMission = Utils.appendedFunction(Mission00.onStartMission, EAS_SettingsMenuExtension.onStartMission)
    FSCareerMissionInfo.saveToXMLFile = Utils.prependedFunction(FSCareerMissionInfo.saveToXMLFile, EAS_SettingsMenuExtension.saveToXMLFile)
end

function EAS_SettingsMenuExtension:onFrameOpen()
    if not self.eas_initSettingsMenuDone then
        g_easUtils:logText("onFrameOpen")

        local target = EAS_SettingsMenuExtension

        self.eas_animalsCanDie = self.checkHelperRefillFuel:clone()
        self.eas_animalsCanDie.target = target
        self.eas_animalsCanDie.id = "eas_animalsCanDie"
        self.eas_animalsCanDie:setCallback("onClickCallback", "onAnimalsCanDieChanged")

        self.eas_animalsCanDie.elements[4]:setText(g_i18n:getText("EAS_SettingsMenu_AnimalsCanDieTitle"))
        self.eas_animalsCanDie.elements[6]:setText(g_i18n:getText("EAS_SettingsMenu_AnimalsCanDieDescription"))

        local title = TextElement.new()
        title:applyProfile("settingsMenuSubtitle", true)
        title:setText(g_i18n:getText("EAS_SettingsMenuTitle"))

        self.boxLayout:addElement(title)
        self.boxLayout:addElement(self.eas_animalsCanDie)

        self.eas_animalsCanDie:setTexts({g_i18n:getText("EAS_SettingsMenu_Off"), g_i18n:getText("EAS_SettingsMenu_On")})
        self.eas_animalsCanDie:setState(EAS_SettingsMenuExtension.animalsCanDieState)

        self.eas_initSettingsMenuDone = true
    end
end

function EAS_SettingsMenuExtension:updateGameSettings()
    g_easUtils:logText("updateGameSettings")
    if self.eas_initSettingsMenuDone and self.eas_animalsCanDie ~= nil then
        self.eas_animalsCanDie:setState(EAS_SettingsMenuExtension.animalsCanDieState)
    end
end

function EAS_SettingsMenuExtension:onAnimalsCanDieChanged(state)
    g_easUtils:logText("onAnimalsCanDieChanged")

    self.animalsCanDieState = state

    if state == 2 then
        self.animalsCanDie = true
    else
        self.animalsCanDie = false
    end

    g_client:getServerConnection():sendEvent(EAS_AnimalsCanDieStateEvent.new(self.animalsCanDieState, self.animalsCanDie))
end

function EAS_SettingsMenuExtension:onStartMission(mission)
    g_easUtils:logText("EAS_SettingsMenuExtension onStartMission")
    if g_server == nil then
        g_client:getServerConnection():sendEvent(EAS_SyncSettingsEvent:new())
        g_easUtils:logText("Send event for sync settings")
    end
end

function EAS_SettingsMenuExtension:saveToXMLFile(missionInfo)
    g_easUtils:logText("saveToXMLFile")

    local savegameDirectory = g_currentMission.missionInfo.savegameDirectory

    if savegameDirectory ~= nil then
        local saveGamePath = savegameDirectory.."/eas_settings.xml"
        local key = "settings"
        local xmlFile = XMLFile.create("settingsXML", saveGamePath, key)

        if xmlFile ~= nil then 		
            xmlFile:setInt(key..".animalsCanDieState", EAS_SettingsMenuExtension.animalsCanDieState)
            xmlFile:setBool(key..".animalsCanDie", EAS_SettingsMenuExtension.animalsCanDie)

            xmlFile:save()
            xmlFile:delete()
            g_easUtils:logText("Settings saved")
        end
    end
end

function EAS_SettingsMenuExtension:loadFromXMLFile(mission)
    g_easUtils:logText("loadSettings")

    local savegameDirectory = g_currentMission.missionInfo.savegameDirectory

    if savegameDirectory ~= nil then
        g_easUtils:logText("savegameDirectory is not nil")
        local filename = savegameDirectory.."/eas_settings.xml"
        local key = "settings"
        local xmlFile = XMLFile.loadIfExists("settingsXML", filename, key)

        if xmlFile ~= nil then
            g_easUtils:logText("xmlFile is not nil")
            EAS_SettingsMenuExtension.animalsCanDieState = xmlFile:getInt(key..".animalsCanDieState") or EAS_SettingsMenuExtension.animalsCanDieState
            EAS_SettingsMenuExtension.animalsCanDie = xmlFile:getBool(key..".animalsCanDie") or EAS_SettingsMenuExtension.animalsCanDie

            xmlFile:delete()
            g_easUtils:logText("Settings loaded")
        end
    end
end
