-- Name: EAS_PlaceableHusbandryAnimalsExtension
-- Author: Chissel

EAS_PlaceableHusbandryAnimalsExtension = {}

function EAS_PlaceableHusbandryAnimalsExtension.addAnimals(self, superFunc, subTypeIndex, numAnimals, age)
    local cluster = g_currentMission.animalSystem:createClusterFromSubTypeIndex(subTypeIndex)

    local subType = g_currentMission.animalSystem:getSubTypeByIndex(subTypeIndex)
    local neededAge = subType.reproductionMinAgeMonth + subType.reproductionDurationMonth

	if cluster:getSupportsMerging() then
		cluster.numAnimals = numAnimals
		cluster.age = age
		cluster.subTypeIndex = subTypeIndex

        if age >= neededAge then
            cluster.hadABirth = true
        end

		self:addCluster(cluster)
	else
		for i = 1, numAnimals do
			cluster = g_currentMission.animalSystem:createClusterFromSubTypeIndex(subTypeIndex)
			cluster.numAnimals = 1
			cluster.age = age

            if age >= neededAge then
                cluster.hadABirth = true
            end

			self:addCluster(cluster)
		end
	end
end

PlaceableHusbandryAnimals.addAnimals = Utils.overwrittenFunction(PlaceableHusbandryAnimals.addAnimals, EAS_PlaceableHusbandryAnimalsExtension.addAnimals)