-- This script prevents loading Enhanced Animal System if a TerraLife Map was detected to prevent Bugs, wrong items and other stuff.
-- By: [F/A] Braeven
-- Date: 18.09.2023
-- Version 1.1.0.0
-- Only for use with EnhancedAnimalSystem/TerraLife, permission for other use can one be given through Braeven / Farming Agency


testTerraLife = {}

function testTerraLife:AddXmlSchema()
	testTerraLife.XmlSchema = XMLSchema.new("terraLife")
	local schema = testTerraLife.XmlSchema
	schema:register(XMLValueType.STRING, "map.terraLife#version", "Required TerraLife Version", nil, nil)
end

function testTerraLife:test()
	local mapDirectory = g_mpLoadingScreen.missionInfo.map.baseDirectory
	if mapDirectory == "" then
		--wenn mapDirectory leer ist, handelt es sich um die Basemaps
		return false
	elseif fileExists(mapDirectory .. "dlcDesc.xml") then
		--wenn dlcDesc existiert, handelt es sich um DLC-Map
		return false
	else
		local path = mapDirectory .. "modDesc.xml"
		local xmlFile = XMLFile.load("TempDesc", path)
		if xmlFile:hasProperty("moddesc.terraLife") then
            xmlFile:delete()
			return true
		else
            xmlFile:delete()
			return false
		end
	end
end

testTerraLife:AddXmlSchema()

if testTerraLife:test() == false then
	source(g_currentModDirectory .. "src/EAS_AddSpecialization.lua")
	source(g_currentModDirectory .. "src/EAS_LoadAnimals.lua")
	source(g_currentModDirectory .. "src/EAS_LoadFillTypes.lua")
	source(g_currentModDirectory .. "src/EAS_AddFillTypeToSellingStation.lua")
	source(g_currentModDirectory .. "src/EAS_IncreaseAnimalMaxAge.lua")
	Logging.info("EAS loaded")
else
	Logging.info("Loading EAS was stopped, TerraLife was detected")
end