-- Name: EAS_AddFillTypeToSellingStation
-- Author: Chissel

EAS_AddFillTypeToSellingStation = {}

function EAS_AddFillTypeToSellingStation.load(self, superFunc, components, xmlFile, key, customEnv, i3dMappings, rootNode)
    local addFillTypes = {"GOATMILK"}
    local neededFillTypes = {[FillType.MILK] = true, [FillType.BUTTER] = true}

    if key == "placeable.sellingStation" then
        xmlFile:iterate(key..".unloadTrigger", function(index,  unloadTriggerKey)
            local fillTypes = xmlFile:getString(unloadTriggerKey.."#fillTypes")

            for _, fillType in pairs(g_fillTypeManager:getFillTypesByNames(fillTypes)) do
                if neededFillTypes[fillType] ~= nil then
                    local fillTypesNew = xmlFile:getString(unloadTriggerKey.."#fillTypes")
                    xmlFile:setString(unloadTriggerKey.."#fillTypes", fillTypesNew.." ".."GOATMILK")
                    break
                end
            end
        end)

        local numberOfFillTypes = -1
        xmlFile:iterate(key..".fillType", function(_, _)
            numberOfFillTypes = numberOfFillTypes + 1
        end)

        xmlFile:iterate(key..".fillType", function(index, fillTypeKey)
            local fillType = g_fillTypeManager:getFillTypeIndexByName(xmlFile:getValue(fillTypeKey .. "#name"))
            if neededFillTypes[fillType] ~= nil then
                for index, fillTypeNameToAdd in pairs(addFillTypes) do
                    local fillTypeToAdd = g_fillTypeManager:getFillTypeByName(fillTypeNameToAdd)
                    xmlFile:setString(key..".fillType("..numberOfFillTypes+index..")#name", fillTypeToAdd.name)
                    xmlFile:setFloat(key..".fillType("..numberOfFillTypes+index..")#priceScale", 1.0)
                    xmlFile:setBool(key..".fillType("..numberOfFillTypes+index..")#supportsGreatDemand", true)
                    xmlFile:setBool(key..".fillType("..numberOfFillTypes+index..")#disablePriceDrop", false)
                end
            end
        end)
    end

    local returnValues = superFunc(self, components, xmlFile, key, customEnv, i3dMappings, rootNode)
    return returnValues
end

SellingStation.load = Utils.overwrittenFunction(SellingStation.load, EAS_AddFillTypeToSellingStation.load)