local modDirectory = g_currentModDirectory or ""
local modName      = g_currentModName or "unknown"
local modEnvironment

source(g_currentModDirectory .. 'moreDustExtension.lua')

local function load(mission)
	assert(g_moreDustExtension == nil)

	modEnvironment = MoreDustExtension:new(mission, g_i18n, modDirectory, modName)

	getfenv(0)["g_moreDustExtension"] = modEnvironment

	if mission:getIsClient() then
		addModEventListener(modEnvironment)
		FSBaseMission.registerActionEvents = Utils.appendedFunction(FSBaseMission.registerActionEvents, MoreDustExtension.registerActionEvents);
		WorkParticles.onUpdateTick         = Utils.overwrittenFunction(WorkParticles.onUpdateTick, MoreDustExtension.onUpdateTickWP)
		Cutter.onUpdateTick                = Utils.overwrittenFunction(Cutter.onUpdateTick, MoreDustExtension.onUpdateTickCutter)
		Combine.onUpdateTick               = Utils.overwrittenFunction(Combine.onUpdateTick, MoreDustExtension.onUpdateTickCombi)
		Baler.onUpdateTick                 = Utils.overwrittenFunction(Baler.onUpdateTick, MoreDustExtension.onUpdateTickBaler)
		Mulcher.onUpdateTick               = Utils.overwrittenFunction(Mulcher.onUpdateTick, MoreDustExtension.onUpdateTickMulch)
		Windrower.onUpdateTick             = Utils.overwrittenFunction(Windrower.onUpdateTick, MoreDustExtension.onUpdateTickWind)
		Mower.onStartWorkAreaProcessing    = Utils.overwrittenFunction(Mower.onStartWorkAreaProcessing, MoreDustExtension.doMower)
		Wheels.onUpdateTick                = Utils.appendedFunction(Wheels.onUpdateTick, MoreDustExtension.onUpdateTickWheels)
		Motorized.onUpdateTick             = Utils.appendedFunction(Motorized.onUpdateTick, MoreDustExtension.onUpdateTickMotorized)

		modEnvironment.loadSettings()
	end
end

local function unload()
	removeModEventListener(modEnvironment)
	modEnvironment                    = nil -- Allows garbage collecting
	getfenv(0)["g_moreDustExtension"] = nil
end

local function init()
	FSBaseMission.delete              = Utils.appendedFunction(FSBaseMission.delete, unload)
	Mission00.load                    = Utils.prependedFunction(Mission00.load, load)

	InGameMenuGeneralSettingsFrame.onFrameOpen = Utils.appendedFunction(InGameMenuGeneralSettingsFrame.onFrameOpen, MoreDustExtension.initGui)

	FSCareerMissionInfo.saveToXMLFile = Utils.appendedFunction(FSCareerMissionInfo.saveToXMLFile, MoreDustExtension.saveSettings)
end

init()
