CutBalesTipHeightTypeEvent = {}

local CutBalesTipHeightTypeEvent_mt = Class(CutBalesTipHeightTypeEvent, Event)
InitEventClass(CutBalesTipHeightTypeEvent, "CutBalesTipHeightTypeEvent")

function CutBalesTipHeightTypeEvent.emptyNew()
    local self = Event.new(CutBalesTipHeightTypeEvent_mt)

    return self
end

function CutBalesTipHeightTypeEvent.new(amount, fillTypeIndex, x, y, z, dirX, dirZ, length, vehicle)
    local self = CutBalesTipHeightTypeEvent.emptyNew()

    self.amount = amount
    self.fillTypeIndex = fillTypeIndex

    self.x = x
    self.y = y
    self.z = z

    self.dirX = dirX
    self.dirZ = dirZ
    self.length = length

    --self.vehicle = vehicle

    return self
end

function CutBalesTipHeightTypeEvent:readStream(streamId, connection)
    self.amount = streamReadFloat32(streamId)
    self.fillTypeIndex = streamReadUIntN(streamId, FillTypeManager.SEND_NUM_BITS)

    self.x = streamReadFloat32(streamId)
    self.y = streamReadFloat32(streamId)
    self.z = streamReadFloat32(streamId)

    self.dirX = streamReadFloat32(streamId)
    self.dirZ = streamReadFloat32(streamId)
    self.length = streamReadUInt8(streamId)

    if streamReadBool(streamId) then
        --self.vehicle = NetworkUtil.readNodeObject(streamId)
    end

    self:run(connection)
end

function CutBalesTipHeightTypeEvent:writeStream(streamId, connection)
    streamWriteFloat32(streamId, self.amount)
    streamWriteUIntN(streamId, self.fillTypeIndex, FillTypeManager.SEND_NUM_BITS)

    streamWriteFloat32(streamId, self.x)
    streamWriteFloat32(streamId, self.y)
    streamWriteFloat32(streamId, self.z)

    streamWriteFloat32(streamId, self.dirX)
    streamWriteFloat32(streamId, self.dirZ)
    streamWriteUInt8(streamId, self.length)

    --if streamWriteBool(streamId, self.vehicle ~= nil) then
    --    NetworkUtil.writeNodeObject(streamId, self.vehicle)
    --end
end

function CutBalesTipHeightTypeEvent:run(connection)
    if not connection:getIsServer() then
        local player = g_currentMission:getPlayerByConnection(connection);
        CutBales:TipToGround(self.amount, self.fillTypeIndex, self.x, self.y, self.z, 0, 0, 0, 0, player);
    end
end
