CutBales = {}

source(g_currentModDirectory.."CutBalesTipHeightTypeEvent.lua");

local CurrentBale = nil
local CutBalesEventId = nil

function CutBales:update()
    if g_currentMission.player == nil then return; end

    CurrentBale = nil

    local x, y, z = localToWorld(g_currentMission.player.cameraNode, 0, 0, 1.0)
    local dx, dy, dz = localDirectionToWorld(g_currentMission.player.cameraNode, 0, 0, -1)
    raycastAll(x, y, z, dx, dy, dz, "raycastCallback", 3, self)

    if CurrentBale ~= nil and CurrentBale.fillType == FillType.COTTON then CurrentBale = nil; end
end

function CutBales:raycastCallback(hitObjectId)
    if hitObjectId == g_currentMission.player.rootNode then
        return true
    end

    for _, SaveItem in pairs (g_currentMission.itemSystem.itemsToSave) do        
        if SaveItem.item.isMissionBale ~= nil and SaveItem.item.nodeId == hitObjectId then
            CurrentBale = SaveItem.item;
            return false;
        end;
    end

    return true
end

function CutBales:loadMap(savegame)
    if g_currentMission:getIsClient() then
        Player.registerActionEvents =
            Utils.appendedFunction(Player.registerActionEvents, CutBales.registerActionEvents)
            Player.updateActionEvents = Utils.appendedFunction(Player.updateActionEvents, CutBales.updateActionEvents)
    end
end

function CutBales:registerActionEvents()
    if self.isClient then
        CutBales.events = {}
		local valid1, eventId1 = g_inputBinding:registerActionEvent(InputAction.CUTACTION,"CUTACTION",CutBales.CutBalesEvent,false,true,false,true)
        if valid1 then
            table.insert(CutBales.events, eventId1);
            g_inputBinding:setActionEventTextVisibility(eventId1, true);
            CutBalesEventId = eventId1;
        end
    end
end

function CutBales:updateActionEvents()
	if CutBalesEventId ~= nil then
    g_inputBinding:setActionEventActive(CutBalesEventId, CurrentBale ~= nil)
	end;
end

function CutBales:CutBalesEvent(actionName, keyStatus, arg3, arg4, arg5)
    if CurrentBale == nil then return; end;

    local FillLevel = CurrentBale.fillLevel;
    local FillType = CurrentBale.fillType;
    local x, y, z = getTranslation(CurrentBale.nodeId);    

    local farmlandId = g_farmlandManager:getFarmlandIdAtWorldPosition(x, z);
    if farmlandId ~= nil then farmlandId = g_farmlandManager:getFarmlandOwner(farmlandId) end;

    if farmlandId ~= 0 and g_currentMission.accessHandler:canFarmAccessOtherId(g_currentMission.player.farmId, farmlandId) and DensityMapHeightUtil.getCanTipToGroundAroundLine(nil, FillLevel, FillType, x, y, z, x + 3 , y, z + 3 , 10, 40, 0, false, nil, nil) then 
        
        CurrentBale:delete();
        g_client:getServerConnection():sendEvent(CutBalesTipHeightTypeEvent.new(FillLevel, FillType, x, y, z, 0, 0, 0, nil));

        return;
    end;
    
    g_currentMission:showBlinkingWarning(g_i18n:getText("warning_youDontHaveAccessToThisLand"), 2000);

end

function CutBales:TipToGround(amount, fillTypeIndex, x, y, z, RdirX, RdirZ, Rlength, Rvehicle, player)
    local length = 3;
    local dirX = 1;
    local dirZ = 1;

    local tipped, lineOffset = DensityMapHeightUtil.tipToGroundAroundLine(nil, amount, fillTypeIndex, x, y, z, x + length * dirX, y, z + length * dirZ, 10, 40, 0, false, nil, nil, true)
    
    local height, heapHeight = DensityMapHeightUtil.getHeightAtWorldPos(x, y, z)
    player:moveTo(x, heapHeight + 0.05, z, false, false)
end;

addModEventListener(CutBales)
