-----------------------------------------------------------------------------------------------------------
-- GEA Cowbarn/Mixfeeder automatic loading normal/Maize+ version 1.1
-----------------------------------------------------------------------------------------------------------
-- Purpose:  Automatic loading of necessary cowbarn in dependency of needed/forbidden Mod Maize+
--
-- Replacement if Maize+ is de-/activated later
--
-- Copyright (c) tn4799, 2023
--
--Changelog
--
--V1.1 fixed game function break on faulty savegame/mod xml (by Braeven)
--
--V1.0 initial version
--
-- Permission granted for use in FS22_CowBarnBig_GEA_Feeder,
-- use or change in other mods forbidden without permission!
--
--Respect the scripters! 
--
--Greetings DSA-Team
-----------------------------------------------------------------------------------------------------------

ModDependencyChecker = {}

function ModDependencyChecker:checkForLoadedMods(superFunc, xmlFile, key, missionInfo, missionDynamicInfo, defaultItemsToSPFarm, callback, target, args)
    local neededMod = xmlFile:getString(key .. "#neededMod")
    local forbiddenMod = xmlFile:getString(key .. "#forbiddenMod")

    if neededMod ~= nil and not g_modIsLoaded[neededMod] then
        return false
    end

    if forbiddenMod ~= nil and g_modIsLoaded[forbiddenMod] then
        return false
    end

    return superFunc(self, xmlFile, key, missionInfo, missionDynamicInfo, defaultItemsToSPFarm, callback, target, args)
end

PlaceableSystem.loadPlaceableFromXML = Utils.overwrittenFunction(PlaceableSystem.loadPlaceableFromXML, ModDependencyChecker.checkForLoadedMods)

function ModDependencyChecker:loadPlaceableFromXML(superFunc, xmlFile, key, missionInfo, missionDynamicInfo, defaultItemsToSPFarm, callback, target, args)
    local filename = xmlFile:getValue(key .. "#filename")
    filename = NetworkUtil.convertFromNetworkFilename(filename)
    local storeItemXmlFile = XMLFile.load("placeableXml", filename, Placeable.xmlSchema)
		--catch function if the savegame is faulty
		if storeItemXmlFile ~=nil then
			local placeableKey = "placeable"
			local neededMods = storeItemXmlFile:getString(placeableKey .. "#neededMods")
			local forbiddenMods = storeItemXmlFile:getString(placeableKey .. "#forbiddenMods")

			if (neededMods ~= nil and not g_modIsLoaded[neededMods]) or (forbiddenMods ~= nil and g_modIsLoaded[forbiddenMods]) then
					local replacement = storeItemXmlFile:getString(placeableKey .. "#replacement")

					if replacement == nil then
							Logging.warning("No replacement for %s specified. Cannot replace store item with one that meets requirements. The store item won't be loaded cause needed mod nor replacement is available.", filename)

							return false
					end
					local _, modDir = Utils.getModNameAndBaseDirectory(filename)
					replacement = modDir .. replacement
					replacement = NetworkUtil.convertToNetworkFilename(replacement)

					xmlFile:setValue(key .. "#filename", replacement)
					Logging.info("Replace %s with %s because requirements are not fullfilled", filename, replacement)
			end
		end

    return superFunc(self, xmlFile, key, missionInfo, missionDynamicInfo, defaultItemsToSPFarm, callback, target, args)
end

PlaceableSystem.loadPlaceableFromXML = Utils.overwrittenFunction(PlaceableSystem.loadPlaceableFromXML, ModDependencyChecker.loadPlaceableFromXML)

function ModDependencyChecker:loadMap(superFunc, ...)
		for idx, storeItem in pairs(g_storeManager.modStoreItems) do
			--separated XML check function, faulty XML no longer leads to break of the entire function
			ModDependencyChecker:checkMod(storeItem.xmlFilename, storeItem.baseDir, idx)
    end

    return superFunc(self, ...)
end

StoreManager.loadMapData = Utils.overwrittenFunction(StoreManager.loadMapData, ModDependencyChecker.loadMap)

function ModDependencyChecker:checkMod(xmlFilename, baseDir, idx)
	local xmlFile = loadXMLFile("storeItemXML", Utils.getFilename(xmlFilename, baseDir))

	if xmlFile == 0 then
		return nil
	end

	local baseXMLName = getXMLRootName(xmlFile)
	local storeItemWasRemoved = false
	if hasXMLProperty(xmlFile, baseXMLName .. "#neededMods") then
			local str = getXMLString(xmlFile, baseXMLName .. "#neededMods") or ""
			local neededMods = str:trim():split(",")

			for _, neededModName in pairs(neededMods) do
					neededModName = neededModName:trim()

					if not g_modIsLoaded[neededModName] then
							table.remove(g_storeManager.modStoreItems, idx)
							storeItemWasRemoved = true
							Logging.info("Removed store item %s because needed mod %s is not loaded", xmlFilename, neededModName)
							break
					end
			end
	end

	if hasXMLProperty(xmlFile, baseXMLName .. "#forbiddenMods") and not storeItemWasRemoved then
			local str = getXMLString(xmlFile, baseXMLName .. "#forbiddenMods") or ""
			local forbiddenMods = str:trim():split(",")

			for _, forbiddenModName in pairs(forbiddenMods) do
					forbiddenModName = forbiddenModName:trim()

					if g_modIsLoaded[forbiddenModName] then
							table.remove(g_storeManager.modStoreItems, idx)
							Logging.info("Removed store item %s because forbidden mod %s is loaded", xmlFilename, forbiddenModName)
							break
					end
			end
	end
end