-- Name: CF_Utils
-- Author: Chissel

local lightFileName = "data/light.i3d"
local modDirectory = g_currentModDirectory

CF_Utils = {}
CF_Utils.lightNode = nil
CF_Utils.rootNode = nil

-- Action Events

function CF_Utils.registerActionEventIfNeeded(self, superFunc, hasMenuButtons)
    superFunc(self, hasMenuButtons)

    CF_Utils:loadLightIfNeeded()

    if CF_Utils.cf_toggleLightEventId ~= nil then
        return
    end

    CF_Utils.rootNode = self.cursor.rootNode

    self.cursor:setLightEnabled(true)

    local _, toggleLightEventId = g_inputBinding:registerActionEvent(InputAction.CF_TOGGLE_LIGHT, CF_Utils, CF_Utils.cf_toggleLight, false, true, false, true)

    if toggleLightEventId == nil then
        return
    end

    g_inputBinding:setActionEventTextVisibility(toggleLightEventId, true)
	g_inputBinding:setActionEventTextPriority(toggleLightEventId, GS_PRIO_HIGH)
    CF_Utils.cf_toggleLightEventId = toggleLightEventId
end

function CF_Utils.unregisterActionEventIfNeeded()
    if CF_Utils.cf_toggleLightEventId == nil then
        return
    end

    g_inputBinding:removeActionEvent(CF_Utils.cf_toggleLightEventId)
    CF_Utils.cf_toggleLightEventId = nil

    if getVisibility(CF_Utils.cf_lightId) then
        CF_Utils:cf_toggleLight()
    end
end

function CF_Utils:mouseEvent(posX, posY, isDown, isUp, button, eventUsed)
    if CF_Utils.lightNode == nil or self.camera.cameraX == nil or self.cursor.currentHitY == nil or self.camera.cameraZ == nil then
        return
    end

	setWorldTranslation(CF_Utils.lightNode, self.camera.cameraX, self.cursor.currentHitY, self.camera.cameraZ)
end

-- Load light functions

function CF_Utils:loadLightIfNeeded()
    if self.cf_lightId ~= nil then
        return
    end

    local lightPath = Utils.getFilename(lightFileName, modDirectory)
    g_i3DManager:loadI3DFileAsync(lightPath, false, false, self.lightLoaded, self, nil)
end

function CF_Utils:lightLoaded(node, failedReason, args)
    if node == nil then
        Logging.error("Load light failed with error: "..failedReason)
        return
    end

    local lightId = getChildAt(node, 0)
    self.cf_lightId = lightId
    self.lightNode = node
    link(getRootNode(), self.lightNode)
    setVisibility(self.cf_lightId, false)
end

-- Toggle light functions

function CF_Utils:cf_toggleLight()
    if self.cf_lightId == nil then
        Logging.error("Light not available")
        return
    end

    local isVisible = getVisibility(self.cf_lightId)
    setVisibility(self.cf_lightId, not isVisible)
end