--[[────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
─██████──────────██████─██████████████─██████████████─██████──██████─██████──────────██████─██████████████─████████──████████─██████████████─████████████████───
─██░░██████████████░░██─██░░░░░░░░░░██─██░░░░░░░░░░██─██░░██──██░░██─██░░██████████──██░░██─██░░░░░░░░░░██─██░░░░██──██░░░░██─██░░░░░░░░░░██─██░░░░░░░░░░░░██───
─██░░░░░░░░░░░░░░░░░░██─██░░██████████─██░░██████████─██░░██──██░░██─██░░░░░░░░░░██──██░░██─██░░██████░░██─████░░██──██░░████─██░░██████████─██░░████████░░██───
─██░░██████░░██████░░██─██░░██─────────██░░██─────────██░░██──██░░██─██░░██████░░██──██░░██─██░░██──██░░██───██░░░░██░░░░██───██░░██─────────██░░██────██░░██───
─██░░██──██░░██──██░░██─██░░██████████─██░░██─────────██░░██████░░██─██░░██──██░░██──██░░██─██░░██──██░░██───████░░░░░░████───██░░██████████─██░░████████░░██───
─██░░██──██░░██──██░░██─██░░░░░░░░░░██─██░░██─────────██░░░░░░░░░░██─██░░██──██░░██──██░░██─██░░██──██░░██─────██░░░░░░██─────██░░░░░░░░░░██─██░░░░░░░░░░░░██───
─██░░██──██████──██░░██─██░░██████████─██░░██─────────██░░██████░░██─██░░██──██░░██──██░░██─██░░██──██░░██───████░░░░░░████───██░░██████████─██░░██████░░████───
─██░░██──────────██░░██─██░░██─────────██░░██─────────██░░██──██░░██─██░░██──██░░██████░░██─██░░██──██░░██───██░░░░██░░░░██───██░░██─────────██░░██──██░░██─────
─██░░██──────────██░░██─██░░██████████─██░░██████████─██░░██──██░░██─██░░██──██░░░░░░░░░░██─██░░██████░░██─████░░██──██░░████─██░░██████████─██░░██──██░░██████─
─██░░██──────────██░░██─██░░░░░░░░░░██─██░░░░░░░░░░██─██░░██──██░░██─██░░██──██████████░░██─██░░░░░░░░░░██─██░░░░██──██░░░░██─██░░░░░░░░░░██─██░░██──██░░░░░░██─
─██████──────────██████─██████████████─██████████████─██████──██████─██████──────────██████─██████████████─████████──████████─██████████████─██████──██████████─
────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────]]--





DamageBarSelection = {}

function DamageBarSelection:updateDamageGauge(superFunc, dt)
	if not self.fadeDamageGaugeAnimation:getFinished() then
		self.fadeDamageGaugeAnimation:update(dt)
	end

	if self.damageGaugeActive then
		local gaugeValue = 1
		local vehicles = self.vehicle.rootVehicle.childVehicles

		for i = 1, #vehicles do
			local vehicle = vehicles[i]

			if vehicle.getIsSelected ~= nil and vehicle:getIsSelected() and vehicle.getDamageAmount ~= nil then
				gaugeValue = 1 - vehicle:getDamageAmount()
			end
		end

		self.damageBarElement:setValue(gaugeValue, "DAMAGE")
		
		local neededColor = SpeedMeterDisplay.COLOR.DAMAGE_GAUGE

		if gaugeValue < 0.2 then
			neededColor = SpeedMeterDisplay.COLOR.DAMAGE_GAUGE_LOW
		end

		self.damageBarElement:setBarColor(neededColor[1], neededColor[2], neededColor[3])
	end
end

SpeedMeterDisplay.updateDamageGauge = Utils.overwrittenFunction(SpeedMeterDisplay.updateDamageGauge, DamageBarSelection.updateDamageGauge)