--
-- AdvancedFarmManager
--

AdditionalInfo = {}

AdditionalInfo.debug     = false
AdditionalInfo.modFolder = g_currentModDirectory
AdditionalInfo.limitTab  = false
AdditionalInfo.limitTabK = nil

source(Utils.getFilename("gui/AIMGui.lua", AdditionalInfo.modFolder))
source(Utils.getFilename("gui/AIMGuiVehicleFrame.lua", AdditionalInfo.modFolder))
source(Utils.getFilename("gui/AIMGuiImplementFrame.lua", AdditionalInfo.modFolder))
source(Utils.getFilename("gui/AIMGuiPlaceableFrame.lua", AdditionalInfo.modFolder))
source(Utils.getFilename("gui/AIMGuiFieldFrame.lua", AdditionalInfo.modFolder))

source(Utils.getFilename("scripts/HotKeyVehicleSystem.lua", AdditionalInfo.modFolder))

addModEventListener(AdditionalInfo)


function AdditionalInfo.prerequisitesPresent(specializations)
    return true
end


function AdditionalInfo:loadMap(name)
    print("~~ AdvancedFarmManager initializing...")
    if AdditionalInfo.debug then
        print("~~ AdvancedFarmManager Debug ... AdditionalInfo:loadMap")
    end

    AdditionalInfo.eventName = {}

    FSBaseMission.registerActionEvents = Utils.appendedFunction(FSBaseMission.registerActionEvents, AdditionalInfo.registerActionEventsPlayer)

    local vehicleFrame   = AIMGuiVehicleFrame:new(g_i18n)
    local implementFrame = AIMGuiImplementFrame:new(g_i18n)
    local placeableFrame = AIMGuiPlaceableFrame:new(g_i18n)
    local fieldFrame     = AIMGuiFieldFrame:new(g_i18n)

    g_gui:loadProfiles(AdditionalInfo.modFolder .. "gui/guiProfiles.xml")

    AdditionalInfo.gui = AIMGui:new(g_messageCenter, g_i18n, g_inputBinding)

    g_gui:loadGui(AdditionalInfo.modFolder .. "gui/AIMGuiVehicleFrame.xml", "AIMGuiVehicleFrame", vehicleFrame, true)
    g_gui:loadGui(AdditionalInfo.modFolder .. "gui/AIMGuiImplementFrame.xml", "AIMGuiImplementFrame", implementFrame, true)
    g_gui:loadGui(AdditionalInfo.modFolder .. "gui/AIMGuiPlaceableFrame.xml", "AIMGuiPlaceableFrame", placeableFrame, true)
    g_gui:loadGui(AdditionalInfo.modFolder .. "gui/AIMGuiFieldFrame.xml", "AIMGuiFieldFrame", fieldFrame, true)
    g_gui:loadGui(AdditionalInfo.modFolder .. "gui/AIMGui.xml", "AIMGui", AdditionalInfo.gui)
end


function AdditionalInfo:loadSavegame()
end


function AdditionalInfo:registerActionEventsPlayer()
    local result, eventName = InputBinding.registerActionEvent(
        g_inputBinding, 'aim_menu',
        self, AdditionalInfo.actionAdditionalInfo_openGui,
        false, true, false, true
    )

    if result then
        table.insert(AdditionalInfo.eventName, eventName)
        g_inputBinding.events[eventName].displayIsVisible = true
    end

    local t_result, t_eventName = InputBinding.registerActionEvent(
        g_inputBinding, 'aim_togg',
        self, AdditionalInfo.actionAdditionalInfo_toggleTab,
        false, true, false, true
    )

    if t_result then
        table.insert(AdditionalInfo.eventName, t_eventName)
        AdditionalInfo.limitTabK = t_eventName

        local l10n_entry = "aim_toggleNotLimited"

        if AdditionalInfo.limitTab then
            l10n_entry = "aim_toggleLimited"
        end

        g_inputBinding:setActionEventText(
            AdditionalInfo.limitTabK, g_i18n:getText(l10n_entry)
        )

        g_inputBinding.events[t_eventName].displayIsVisible = true
    end


    for i = 1, 9 do
        local l_result, l_eventName = InputBinding.registerActionEvent(
            g_inputBinding, 'aim_hot' .. tostring(i),
            self, AdditionalInfo.actionAdditionalInfo_hotKey,
            false, true, false, true
        )

        if l_result then
            table.insert(AdditionalInfo.eventName, l_eventName)
            g_inputBinding.events[l_eventName].displayIsVisible = false
        end
    end

    if AdditionalInfo.debug then
        print("~~ AdvancedFarmManager Debug ... AdditionalInfo:registerActionEventsPlayer")
    end
end


function AdditionalInfo:removeActionEventsPlayer()
    AdditionalInfo.eventName = {}
    if AdditionalInfo.debug then
        print("~~ AdvancedFarmManager Debug ... AdditionalInfo:removeActionEventsPlayer")
    end
end


function AdditionalInfo:actionAdditionalInfo_hotKey(actionName, keyStatus, arg3, arg4, arg5)
    if g_gui.currentGui == nil then
        local keyPressed = tonumber(string.sub(actionName, -1))

        if g_currentMission.player ~= nil then
            local alreadyDone = false
            for _, vehicle in ipairs(g_currentMission.vehicles) do
                local hasAccess        = g_currentMission.accessHandler:canPlayerAccess(vehicle)
                local hasEnter         = vehicle.spec_enterable ~= nil
                local hasSpec          = vehicle.getHotKeyVehicleState ~= nil
                local isConned         = vehicle.getIsControlled ~= nil and vehicle:getIsControlled()

                if not alreadyDone and hasSpec and hasEnter and hasAccess then
                    if vehicle:getHotKeyVehicleState() == keyPressed then
                        alreadyDone = true
                        if not isConned then
                            -- available, switch to it
                            g_currentMission:requestToEnterVehicle(vehicle)
                        end
                    end
                end
            end
        end
    end
end


function AdditionalInfo:actionAdditionalInfo_openGui(actionName, keyStatus, arg3, arg4, arg5)
    if g_gui.currentGui == nil then
        g_gui:showGui("AIMGui")
    end
end

function AdditionalInfo:actionAdditionalInfo_toggleTab(actionName, keyStatus, arg3, arg4, arg5)
    AdditionalInfo.limitTab = not AdditionalInfo.limitTab
    local l10n_entry = "aim_toggleNotLimited"

    if AdditionalInfo.limitTab then
        l10n_entry = "aim_toggleLimited"
    end

    g_inputBinding:setActionEventText(
        AdditionalInfo.limitTabK, g_i18n:getText(l10n_entry)
    )
end


function AdditionalInfo:mouseEvent(posX, posY, isDown, isUp, button)
end


function AdditionalInfo:keyEvent(unicode, sym, modifier, isDown)
    if isDown and g_gui.currentGui ~= nil  and g_gui.currentGui.name == "AIMGui" and g_gui.currentGui.target.currentPageName == "AIMGuiVehicle" then
        if ( sym > 48 and sym < 58 ) or ( sym > 256 and sym < 266) then
            local numberKeyPressed  = 0
            if sym > 58 then
                numberKeyPressed  = sym - 256
            else
                numberKeyPressed  = sym - 48
            end
            local vehicleList       = g_gui.currentGui.target.pageAIMVehicles.vehicles
            local currentVehicleIdx = g_gui.currentGui.target.pageAIMVehicles.vehicleList.selectedIndex
            local currentVehicle    = vehicleList[currentVehicleIdx]

            if currentVehicle.getHotKeyVehicleState ~= nil then
                local currentHotKey = currentVehicle:getHotKeyVehicleState()
                if currentHotKey == numberKeyPressed then
                    -- unset current
                    currentVehicle:setHotKeyVehicleState(0)
                else
                    -- set new
                    for _, vehicleIttr in ipairs(vehicleList) do
                        if vehicleIttr.getHotKeyVehicleState ~= nil and vehicleIttr:getHotKeyVehicleState() == numberKeyPressed then
                            vehicleIttr:setHotKeyVehicleState(0)
                        end
                    end
                    currentVehicle:setHotKeyVehicleState(numberKeyPressed)
                end
            end
            g_gui.currentGui.target.pageAIMVehicles:rebuildTable()
        end
    end
end

function AdditionalInfo:buildHotKeyList()
    local vehicleList       = g_currentMission.enterables
    local hotKeyList        = {}
    local hotKeyKeyList     = {}

    for _, thisVehicle in ipairs(vehicleList) do
        if thisVehicle.getHotKeyVehicleState ~= nil and thisVehicle:getIsTabbable() and thisVehicle:getIsEnterable() then
            local thisHotKey = thisVehicle:getHotKeyVehicleState()
            if thisHotKey > 0 then
                hotKeyList[thisHotKey] = thisVehicle
                table.insert(hotKeyKeyList, thisHotKey)
            end
        end
    end

    table.sort(hotKeyKeyList)

    return hotKeyList, hotKeyKeyList
end

function AdditionalInfo:getClosestHK(haystack, needle)
    local goBack   = 0
    local goFwd    = 10
    local firstIdx = 0
    local lastIdx  = 10

    for _, idx in ipairs(haystack) do
        if firstIdx == 0 then
            firstIdx = idx
        end
        if idx > goBack and idx < needle then
            goBack = idx
        end
        if idx < goFwd and idx > needle then
            goFwd = idx
        end
        lastIdx = idx
    end

    if goBack == 0 then
        goBack = lastIdx
    end
    if goFwd == 10 then
        goFwd = firstIdx
    end

    return goFwd, goBack
end

function AdditionalInfo:findNextHotKey(currentHotKey, directionFwd)
    local hotKeyList, hotKeyKeyList = self:buildHotKeyList()

    if hotKeyKeyList == nil or next(hotKeyList) == nil then
        return false
    end

    if currentHotKey == 0 then
        if directionFwd then
            if hotKeyKeyList[1] == nil then
                return false
            end
            return hotKeyList[hotKeyKeyList[1]]
        end
        if hotKeyKeyList[#hotKeyKeyList] == nil then
            return false
        end
        return hotKeyList[hotKeyKeyList[#hotKeyKeyList]]
    end

    local goFwd, goBack = self:getClosestHK(hotKeyKeyList, currentHotKey)

    if directionFwd then
        return hotKeyList[goFwd]
    else
        return hotKeyList[goBack]
    end

    return false
end


function AdditionalInfo:toggleVehicle(superFunc, delta)
    if not g_currentMission.isToggleVehicleAllowed then
        return
    end

    if AdditionalInfo.limitTab then
        if AdditionalInfo.debug then
            print("~~ AdvancedFarmManager Debug ... toggleVehicle enhanced")
        end

        local currentHotKey = 0

        if not g_currentMission.controlPlayer and g_currentMission.controlledVehicle ~= nil and g_currentMission.controlledVehicle.getHotKeyVehicleState ~= nil then
            currentHotKey = g_currentMission.controlledVehicle:getHotKeyVehicleState()
        end

        local nextHotKeyVehicle = AdditionalInfo:findNextHotKey(currentHotKey, (delta > 0))

        if AdditionalInfo.debug then
            print("~~ AdvancedFarmManager Debug ... Current Vehicle HK: " .. currentHotKey)
            print("~~ AdvancedFarmManager Debug ... Next Vehicle Table: " .. tostring(nextHotKeyVehicle))
        end

        if (type(nextHotKeyVehicle) ~= "table") then
            g_currentMission:showBlinkingWarning(g_i18n:getText("aim_noAvailVehicle"), 2000)
        else
            g_currentMission:requestToEnterVehicle(nextHotKeyVehicle)
        end
    else
        if AdditionalInfo.debug then
            print("~~ AdvancedFarmManager Debug ... toggleVehicle vanilla")
        end
        superFunc(self, delta)
    end
end


function AdditionalInfo:update(dt)
end


function AdditionalInfo:draw()
end


local function validateVehicleTypes(typeManager)
    if typeManager.typeName == "vehicle" then
        g_HotKeyVehicleSystem:installSpecialization(g_vehicleTypeManager, g_specializationManager)
    end
end


function AdditionalInfo:loadMapDataHelpLineManager(superFunc, ...)
    local ret = superFunc(self, ...)
    if ret then
        self:loadFromXML(Utils.getFilename("help/HelpMenu.xml", AdditionalInfo.modFolder))
        return true
    end
    return false
end


function AdditionalInfo:GuiOverlay_loadOverlay(superFunc, overlay, overlayName, imageSize, profile, xmlFile, key)
    local t_overlay = superFunc(self, overlay, overlayName, imageSize, profile, xmlFile, key)

    if t_overlay == nil then
        return nil
    end

    if t_overlay.filename == "g_AIMExtraIcons" then
        t_overlay.filename = g_AIMExtraIcons
    end

    return t_overlay
end


local function init()
    g_AIMExtraIcons             = Utils.getFilename("icons/AIM_icon_extra.dds", AdditionalInfo.modFolder)
    GuiOverlay.loadOverlay      = Utils.overwrittenFunction(GuiOverlay.loadOverlay, AdditionalInfo.GuiOverlay_loadOverlay)
    g_HotKeyVehicleSystem       = HotKeyVehicleSystem:new(g_currentModName, AdditionalInfo.modFolder, g_inputBinding, AdditionalInfo.debug)
    TypeManager.validateTypes   = Utils.prependedFunction(TypeManager.validateTypes, validateVehicleTypes)
    HelpLineManager.loadMapData = Utils.overwrittenFunction(HelpLineManager.loadMapData, AdditionalInfo.loadMapDataHelpLineManager)
    BaseMission.toggleVehicle   = Utils.overwrittenFunction(BaseMission.toggleVehicle, AdditionalInfo.toggleVehicle)
end

init()
