--
-- AdvancedFarmManager - GUI Layout
--

AIMGui = {}

local AIMGui_mt = Class(AIMGui, TabbedMenu)

AIMGui.CONTROLS = {
    'pageAIMVehicles',
    'pageAIMImplements',
    'pageAIMPlaceables',
    'pageAIMFields',
}

function AIMGui:new(messageCenter, l18n, inputManager)
    local self = TabbedMenu.new(nil, AIMGui_mt, messageCenter, l18n, inputManager)

    self:registerControls(AIMGui.CONTROLS)

    self.messageCenter = messageCenter
    self.l18n          = l18n
    self.inputManager  = g_inputBinding

    return self
end

function AIMGui:onGuiSetupFinished()
    AIMGui:superClass().onGuiSetupFinished(self)

    self.clickBackCallback = self:makeSelfCallback(self.onButtonBack)

    self.pageAIMVehicles:initialize()
    self.pageAIMImplements:initialize()
    self.pageAIMPlaceables:initialize()
    self.pageAIMFields:initialize()

    self:initData()

    self:setupPages()

    self:setupMenuButtonInfo()
end

function AIMGui:setupPages()
    local pages = {
        {self.pageAIMVehicles,   'AIM_icon_vehicle.png'},
        {self.pageAIMImplements, 'AIM_icon_attach.png'},
        {self.pageAIMPlaceables, 'AIM_icon_placable.png'},
        {self.pageAIMFields,     'AIM_icon_field.png'},
    }

    for idx, thisPage in ipairs(pages) do
        local page, icon = unpack(thisPage)
        self:registerPage(page, idx)
        self:addPageTab(page, AdditionalInfo.modFolder .. 'icons/' .. icon)
    end
end

function AIMGui:initData()
    if AdditionalInfo.debug then
        print("~~ AdvancedFarmManager Debug ... AIMGui:initData")
    end
end

function AIMGui:setupMenuButtonInfo()
    local onButtonBackFunction = self.clickBackCallback;

    self.defaultMenuButtonInfo = {
        {
            inputAction = InputAction.MENU_BACK,
            text        = g_i18n:getText("button_back"),
            callback    = onButtonBackFunction
        },
        {
            inputAction = InputAction.MENU_ACTIVATE,
            text        = g_i18n:getText("button_back"),
            callback    = onButtonBackFunction
        }
    }

    self.defaultMenuButtonInfoByActions[InputAction.MENU_BACK]     = self.defaultMenuButtonInfo[1]

    self.defaultButtonActionCallbacks = {
        [InputAction.MENU_BACK] = onButtonBackFunction,
    }
end

function AIMGui:exitMenu()
    if AdditionalInfo.debug then
        print("~~ AdvancedFarmManager Debug ... AIMGui:exitMenu")
    end
    self:initData()
    self:changeScreen()
end
